/*
 * Decompiled with CFR 0.152.
 */
package dev.codenmore.tilegame;

import dev.codenmore.tilegame.Handler;
import dev.codenmore.tilegame.display.Display;
import dev.codenmore.tilegame.gfx.Assets;
import dev.codenmore.tilegame.gfx.GameCamera;
import dev.codenmore.tilegame.input.KeyManager;
import dev.codenmore.tilegame.input.MouseManager;
import dev.codenmore.tilegame.states.CharacterSelectionState;
import dev.codenmore.tilegame.states.EndGameState;
import dev.codenmore.tilegame.states.GameState;
import dev.codenmore.tilegame.states.InstructionsState;
import dev.codenmore.tilegame.states.MapSelectionState;
import dev.codenmore.tilegame.states.MenuState;
import dev.codenmore.tilegame.states.PauseState;
import dev.codenmore.tilegame.states.State;
import java.awt.Graphics;
import java.awt.image.BufferStrategy;

public class Game
implements Runnable {
    private Display display;
    public String title;
    private int width;
    private int height;
    private boolean running = false;
    private Thread thread;
    private BufferStrategy bs;
    private Graphics g;
    private State gameState;
    private State pauseState;
    private State menuState;
    private State instructionsState;
    private State characterSelectionState;
    private State mapSelectionState;
    private State endGameState;
    private State currentState;
    private String currentStateName;
    private KeyManager keyManager;
    private MouseManager mouseManager;
    private GameCamera gameCamera;
    private Handler handler;
    int q = 0;

    public Game(String title, int width, int height) {
        this.title = title;
        this.width = width;
        this.height = height;
    }

    private void init() {
        this.keyManager = new KeyManager(this.handler);
        this.handler = new Handler(this);
        this.mouseManager = new MouseManager(this.g, this.handler);
        this.display = new Display(this.title, this.width, this.height);
        this.display.getFrame().addKeyListener(this.keyManager);
        this.display.getFrame().addMouseListener(this.mouseManager);
        this.display.getFrame().addMouseMotionListener(this.mouseManager);
        this.display.getCanvas().addMouseListener(this.mouseManager);
        this.display.getCanvas().addMouseMotionListener(this.mouseManager);
        Assets.init();
        this.gameCamera = new GameCamera(this.handler, 0.0f, 0.0f);
        this.characterSelectionState = new CharacterSelectionState(this.handler);
        this.mapSelectionState = new MapSelectionState(this.handler);
        this.gameState = new GameState(this.handler, this.g);
        this.pauseState = new PauseState(this.handler);
        this.menuState = new MenuState(this.handler);
        this.instructionsState = new InstructionsState(this.handler);
        this.endGameState = new EndGameState(this.handler);
        State.setState(this.menuState);
        this.currentState = this.menuState;
        this.currentStateName = "menuState";
    }

    private void tick() {
        this.keyManager.tick();
        if (State.getState() != null) {
            State.getState().tick();
        }
    }

    private void render() {
        this.bs = this.display.getCanvas().getBufferStrategy();
        if (this.bs == null) {
            this.display.getCanvas().createBufferStrategy(3);
            return;
        }
        this.g = this.bs.getDrawGraphics();
        this.g.clearRect(0, 0, this.width, this.height);
        if (State.getState() != null) {
            State.getState().render(this.g);
        }
        this.bs.show();
        this.g.dispose();
    }

    @Override
    public void run() {
        this.init();
        int fps = 60;
        double timePerTick = 1000000000 / fps;
        double delta = 0.0;
        long lastTime = System.nanoTime();
        while (this.running) {
            long now = System.nanoTime();
            delta += (double)(now - lastTime) / timePerTick;
            lastTime = now;
            if (!(delta >= 1.0)) continue;
            this.tick();
            this.render();
            delta -= 1.0;
        }
        this.stop();
    }

    public GameState getGameState() {
        return (GameState)this.gameState;
    }

    public Display getDisplay() {
        return this.display;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public MouseManager getMouseManager() {
        return this.mouseManager;
    }

    public GameCamera getGameCamera() {
        return this.gameCamera;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getCurrentStateName() {
        System.out.println("pop");
        return this.currentStateName;
    }

    public void setCurrentState(String s) {
        if (s.equals("menuState")) {
            System.out.println("poptart");
            this.currentState = this.menuState;
            this.currentStateName = s;
        } else if (s.equals("instructionsState")) {
            this.currentState = this.instructionsState;
            this.currentStateName = s;
        } else if (s.equals("characterSelectionState")) {
            this.currentState = this.characterSelectionState;
            this.currentStateName = s;
        } else if (s.equals("mapSelectionState")) {
            this.currentState = this.mapSelectionState;
            this.currentStateName = s;
        } else if (s.equals("gameState")) {
            this.currentState = this.gameState;
            this.currentStateName = s;
        } else if (s.equals("pauseState")) {
            this.currentState = this.pauseState;
            this.currentStateName = s;
        } else if (s.equals("endGameState")) {
            this.currentState = this.endGameState;
            this.currentStateName = s;
        }
        State.setState(this.currentState);
    }

    public State getCharacterSelectionState() {
        return this.characterSelectionState;
    }
}

